
/*
 * MyString.h
 *
 * This is the MyString string class.
 *
 * Version 0.5
 *   -- Fix minor incompatabilities with various compilers
 *   --Added operators from Assignment 6
 *   --Fixed up overloaded >> operator to deal with file input
 *   --Added getAllocatedSpace() and setAllocatedSpace()
 * Version 0.6
 *   --Added operators from Assignment 6
 *   --Fixed up overloaded >> operator to deal with file input
 *   --Added getAllocatedSpace() and setAllocatedSpace()
 * Version 0.7
 *   --Fixed problem of not always catching EOF in overloaded >>
 *   --Added "return *this" statements at the end of overloaded +=
 *     operators in which they were missing
 *   --Fixed bug in which setValue() wasn't accounting for the NULL
 *     byte when determining if enough space existed.
 * Version 0.8
 *   --Added #ifdef _MYSTRING to header file
 */

#ifndef _MYSTRING
#define _MYSTRING 

#include <string>

using namespace std;

class MyString
{
public:
  // Memory management
  void *operator new(size_t);
  void operator delete(void *d);

  // Constructors
  MyString();                 // default constructor
  MyString(string);           // set initial string value
  MyString(int);              // set initial storage size
  MyString(MyString &aCopy);  // smarter copy constructor
  
  // Destructor
  virtual ~MyString();
  
  // Operator overloads
  MyString &operator=(const MyString &sourceStr);
  int operator~();
  char &operator[](int i) const;
  operator string() const;
  
  operator char *() const;
  MyString &operator=(char *);
  MyString &operator=(string aStr);

  MyString &operator+=(const MyString &str);
  MyString &operator+=(const string &cppStr);
  MyString &operator+=(const char *cStr);
  
  string MakeString() const;
  int MakeInt() const;
  bool setValue(string newValue);
  
  // Here comes the declarations for the overloaded
  // readString() member function.
  int readString();
  int readString(int maxSpace);
  
  int findChar(char c,int startPos=0,int stopPos=-1);
  char &element(int i) const;
  
  // Added member function to get Allocated Space
  int getAllocatedSpace() 
  {  
    return allocatedSpace;
  }
  
  // Added member function to set allocated space
  bool setAllocatedSpace(int newSize)
  {
    return growStorage(newSize);
  }
    
private:
  bool growStorage(int);
  char *storagePtr;
  char initialStorage[20];
  int allocatedSpace;
  int stringLength;
};

inline MyString operator+(const MyString &str1, const MyString &str2)
{
  MyString retStr((str1.MakeString())+(str2.MakeString()));
  return retStr;
}



// Assignment 6 inline binary operators
inline bool operator==(const MyString &str1,const MyString &str2)
{
  if (!strcmp((char *)str1,(char *)str2))
    return true;
  return false;
}

inline bool operator<(const MyString &str1,const MyString &str2)
{
  if (strcmp((char *)str1,(char *)str2) < 0)
    return true;
  return false;
}

inline bool operator>(const MyString &str1,const MyString &str2)
{
  if (strcmp((char *)str1,(char *)str2) > 0)
    return true;
  return false;
}

inline bool operator>=(const MyString &str1,const MyString &str2)
{
  if (strcmp((char *)str1,(char *)str2) >= 0)
    return true;
  return false;
}


inline bool operator<=(const MyString &str1,const MyString &str2)
{
  if (strcmp((char *)str1,(char *)str2) <= 0)
    return true;
  return false;
}


// Overload the << operator to output directly from a "MyString"
inline ostream& operator<<(ostream &os,MyString &myStr)
{
  os << (char *) myStr;
  return os;
}

// Overload the >> operator to read in directly to a "MyString"
// Slightly different from what we originally defined in class, 
// it handles input from files much better!
inline istream& operator>>(istream &is,MyString &myStr)
{
  int allocatedSpace = myStr.getAllocatedSpace();
  char *tempBuf = new char[allocatedSpace];
  
  if (tempBuf)
  {
    char ch;
    char eofChar = EOF;
    int index =0;
    *tempBuf = '\0';
    while (true)
    {
      ch = EOF;
      is.get(ch);
      if ((ch == '\n') || (ch == eofChar) || (ch == '\0'))
        break;
    
      // Make sure we aren't stepping over the bounds of our
      // allocated space (leave a byte for the NULL terminator)
      if (index >= (allocatedSpace-1))
        continue;
      
      tempBuf[index++] = ch;
    }
 
    tempBuf[index] = '\0';
    string tempStr = tempBuf;
    myStr.setValue(tempStr);
    delete [] tempBuf;  
  }
  else
    myStr.setValue("");
    
  return is;
}

#endif